function OnIframeLoad() {
	if(!window.firstLoad){
		var checkerAuthWrap = document.getElementById('checker-auth');
		var iframe = document.getElementById('iframe');
		let unicIDSessionPlugin = loadLS(KROCK_CONSTANTS.STORAGE_KEY_ID_SESSION);
		if(!unicIDSessionPlugin){
			let unicID = getSecureRandomString(32);
			saveLS(KROCK_CONSTANTS.STORAGE_KEY_ID_SESSION, unicID);
			unicIDSessionPlugin = unicID;
		}

		let token = loadLS(KROCK_CONSTANTS.STORAGE_KEY_TOKEN);
		if(!token){
			let iframeSrc = KROCK_CONSTANTS.IFRAME_SRC + getIframeExtra()+'&unic-id-session-plugin='+unicIDSessionPlugin;
			window.firstLoad = true;
			iframe.src = iframeSrc;
		} else {
			let iframeSrc = KROCK_CONSTANTS.IFRAME_AUTH + getIframeExtra()+'&token='+token+'&unic-id-session-plugin='+unicIDSessionPlugin;
			window.firstLoad = true;
			iframe.src = iframeSrc;
		}
		sendAnalyticsEvent();
		const eventTimestamps = new Map();
		const EVENT_THRESHOLD = 1000; // miliseconds
		window.addEventListener('message', (event) => {
			if (!event.data || !event.data.event) return;
			const eventName = event.data.event;
			const now = Date.now();
			if (eventTimestamps.has(eventName)) {
				const lastTimestamp = eventTimestamps.get(eventName);
				if (now - lastTimestamp < EVENT_THRESHOLD) {
					return; // Ignore duplicate
				}
			}
			eventTimestamps.set(eventName, now);
			console.log('Event in iframe:', event.data, ' time:', new Date(now).toISOString());


			//if (event.origin !== KROCK_CONSTANTS.IFRAME_ORIGIN) return;

			if(event.data.event == "startSession"){
				if(event.data.data){
					saveLS(KROCK_CONSTANTS.STORAGE_KEY_TOKEN, event.data.data);
					iframe.src = KROCK_CONSTANTS.IFRAME_AUTH + getIframeExtra()+'&token='+event.data.data+'&unic-id-session-plugin='+unicIDSessionPlugin;
				}
			}
			if(event.data.event == "startGoogleAuth"){
				const authUrl = event.data.data;
				KROCK_CONSTANTS.GLOBAL_CSINTERFACE.openURLInDefaultBrowser(decodeURI(authUrl));
				CheckAuthGoogle(unicIDSessionPlugin);
			}

			//console.log('STORAGE_TEMP_PLAYHEAD: '+KROCK_CONSTANTS.STORAGE_TEMP_PLAYHEAD);
			if(KROCK_CONSTANTS.STORAGE_TEMP_PLAYHEAD == true){
				if(event.data.event == "playerChangeCurrentTime"){
					const timeInSeconds = parseFloat(event.data.data.currentTime);
					if (!isNaN(timeInSeconds)) {
						if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
							KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(`$._ext.setPlayheadTime(${timeInSeconds})`, (result) => {
								if (result) {
									console.log("Result:", result);
								} else {
									console.error("EvalScript failed.");
								}
							});
						} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
							KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(`$._ext.setPlayheadTimeAEFT(${timeInSeconds})`, (result) => {
								if (result) {
									//console.log("Result:", result);
								} else {
									//console.error("EvalScript failed.");
								}
							});
						}
					} else {
						//alert("Please enter a valid number.");
					}
				}
				if(event.data.event == "playerPlay"){
					//PLAY
					const timeInSeconds = parseFloat(event.data.data.currentTime);
					if (!isNaN(timeInSeconds)) {
						if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
							KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(`$._ext.setPlayheadTime(${timeInSeconds})`, (result) => {
								KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('$._ext.play()', (play) => {
									if (play) {
										console.log("play/Result:");
										console.log(play);
									}
								});
							});
						} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
							KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(`$._ext.setPlayheadTimeAEFT(${timeInSeconds})`, (result) => {
								KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('$._ext.playPauseAEFT()', (play) => {
									if (play) {
										// console.log("play/Result:");
										// console.log(play);
									}
								});
							});
						}
					}
				}
				if(event.data.event == "playerPause"){
					//PAUSE
					if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
						KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('$._ext.pause()', (pause) => {
							if (pause) {
								const timeInSeconds = parseFloat(event.data.data.currentTime);
								if (!isNaN(timeInSeconds)) {
									KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(`$._ext.setPlayheadTime(${timeInSeconds})`, (result) => {});
								}
							}
						});
					} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
						KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('$._ext.playPauseAEFT()', (pause) => {
							if (pause) {
								const timeInSeconds = parseFloat(event.data.data.currentTime);
								if (!isNaN(timeInSeconds)) {
									KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(`$._ext.setPlayheadTimeAEFT(${timeInSeconds})`, (result) => {});
								}
							}
						});
					}
				}
				if(event.data.event == "copyClipboard"){
					//copyClipboard
					if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
						console.log("DATA:");
						console.log(event.data.data.text);
						copyToClipboard(event.data.data.text);
					} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
						console.log("DATA:");
						console.log(event.data.data.text);
						copyToClipboard(event.data.data.text);
					}
				}
			}
		}); 
	}

	async function sendAnalyticsEvent() {
			try {
				const csInterface = new CSInterface();
  				const appId = csInterface.getHostEnvironment().appId;
				const response = await fetch(KROCK_CONSTANTS.IFRAME_ORIGIN+"/api/web/v1/auth/plugin-login-event?plugin="+appId);
				const data = await response.json();
				console.log("Response Data Analytics Event:", data);
			} catch (error) {
				console.error("Error fetching data:", error);
			}
	}
	// Check Auth Google
	function CheckAuthGoogle(unicIDSessionPlugin){
		checkerAuthWrap.classList.add('active');
		let counter = 60;
		const counterElement = document.getElementById("counterAuth");

		function updateCounter() {
			counterElement.textContent = counter+' sec';
		}
		const interval = setInterval(() => {
			updateCounter();
			
			if (counter % 5 === 0) {
				sendRequest();
			}
			if (counter === 0) {
				clearInterval(interval);
				checkerAuthWrap.classList.remove('active');
			}
			counter--;
		}, 1000);
		async function sendRequest() {
			try {
				const response = await fetch(KROCK_CONSTANTS.IFRAME_ORIGIN+"/api/web/v1/auth-plugin/fetch-auth?unic-id-session-plugin="+unicIDSessionPlugin);
				const data = await response.json();
				
				if (data.data.status === "success") {
					console.log("Response Data:", data);
					clearInterval(interval);
					checkerAuthWrap.classList.remove('active');

					saveLS(KROCK_CONSTANTS.STORAGE_KEY_TOKEN, data.data.token);
					iframe.src = KROCK_CONSTANTS.IFRAME_AUTH + getIframeExtra()+'&token='+data.data.token+'&unic-id-session-plugin'+unicIDSessionPlugin;
				}
			} catch (error) {
				console.error("Error fetching data:", error);
			}
		}
		updateCounter();
	}

	// copy clipboard
	async function copyToClipboard(text) {
		// fallback
		const textarea = document.createElement("textarea");
		textarea.value = text;
		textarea.style.position = "fixed";
		textarea.style.opacity = "0";
		document.body.appendChild(textarea);
		textarea.focus();
		textarea.select();
		try {
			document.execCommand("copy");
			return true;
		} catch (err) {
			console.error("Fallback не сработал:", err);
			return false;
		} finally {
			document.body.removeChild(textarea);
		}
	}


	function loadLS(name) {
		const savedValue = localStorage.getItem(name);
		if (savedValue) {
			return savedValue;
		}
	}
	function saveLS(name, value) {
		localStorage.setItem(name, value);
	}
	function getSecureRandomString(length) {
		const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
		const array = new Uint8Array(length);
		crypto.getRandomValues(array);
		return Array.from(array, byte => characters[byte % characters.length]).join('');
	}
}


