async function onLoaded() {
    window.firstLoad = false;
    KROCK_CONSTANTS.GLOBAL_CSINTERFACE = new CSInterface();
    KROCK_CONSTANTS.SCRIPT_OBJECT = new MainScript();
    KROCK_CONSTANTS.SCRIPT_OBJECT.initialiseJS();

    let hostEnv = JSON.parse(window.__adobe_cep__.getHostEnvironment());     
    KROCK_CONSTANTS.APP_NAME = hostEnv.appName;
    KROCK_CONSTANTS.APP_VERSION = hostEnv.appVersion;
}

MainScript.prototype.initialiseJS = function () {
    var extensionRoot = KROCK_CONSTANTS.GLOBAL_CSINTERFACE.getSystemPath(SystemPath.EXTENSION) + "/jsx";
    var jsonScript = extensionRoot+'/json.jsx';
    KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('$._ext.evalFiles("' + jsonScript + '")', (result) => {
        if (result) {
            console.log("Init json script:");
            console.log(result);
        } else {
            console.error("EvalScript failed.");
        }
    });
    var jsonScript = extensionRoot+'/functions.jsx';
    KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('$._ext.evalFiles("' + jsonScript + '")', (result) => {
        if (result) {
            console.log("Init json script:");
            console.log(result);
        } else {
            console.error("EvalScript failed.");
        }
    });
}


function MainScript() {}