// All of the Node.js APIs are available in the preload process.
const { contextBridge, ipcRenderer } = require('electron')

const timelineProxy = {
    AddMarker: async (frameId, color, name, note, duration, customData) => {
        try {
            return await ipcRenderer.invoke('timeline:addMarker', frameId, color, name, note, duration, customData);
        } catch (error) {
            console.error('Error in AddMarker:', error);
            throw error;
        }
    },
    SetPlayheadTime: async (timecode) => {
        try {
            return await ipcRenderer.invoke('timeline:setPlayheadTime', timecode);
        } catch (error) {
            console.error('Error in Set playhead time:', error);
            throw error;
        }
    },
    GetMarkers: async (customData) => {
        try {
            return await ipcRenderer.invoke('timeline:getMarkers', customData);
        } catch (error) {
            console.error('Error in clear Import Markers:', error);
            throw error;
        }
    },
    DeleteMarker: async (customData) => {
        try {
            return await ipcRenderer.invoke('timeline:deleteMarkerByCustomData', customData);
        } catch (error) {
            console.error('Error in delete Marker:', error);
            throw error;
        }
    },
};


contextBridge.exposeInMainWorld('appAPI', {
    trackCount: (trackType) => ipcRenderer.invoke('resolve:trackCount', trackType),
    getCurrentTimeline: () => Promise.resolve(timelineProxy),
    confirmDialog: (options) => ipcRenderer.invoke('show-confirm', options),
});

window.addEventListener('DOMContentLoaded', () => {
  const replaceText = (selector, text) => {
    const element = document.getElementById(selector)
    if (element) element.innerText = text
  }

  for (const dependency of ['chrome', 'node', 'electron']) {
    replaceText(`${dependency}-version`, process.versions[dependency])
  }
});