if (typeof ($) == 'undefined')
    $ = {};

$._ext = {
    /////////////////
    // PREMIERE PRO
    /////////////////
    evalFiles: function(jsxFile){
        $.evalFile(jsxFile);
        return 'YES';
    },
    play: function() {
        try {
			app.enableQE();
			qe.startPlayback();
            return true;
		} catch(error) {
			return error.message
		}
    },
    pause: function () {
        try {
			app.enableQE();
			qe.stopPlayback();
            return true;
		} catch(error) {
			return error.message
		}
    },
    setPlayheadTime: function (timeInSeconds) {
        try {
            if (app.project && app.project.activeSequence) {
                var sequence = app.project.activeSequence;
                var ticks = parseInt(timeInSeconds * 254016000000);
                sequence.setPlayerPosition(ticks.toString()); // Number frame
                return "Playhead set to " + timeInSeconds + " seconds.";
            } else {
                return "No active sequence found.";
            }
        } catch (e) { alert("Exception3:" + e.message); }
    },
    addMarkersToTimeline: function (xMarker) {
        var marker = JSON.parse(xMarker);
        if (app.project && app.project.activeSequence) {
            var comp = app.project.activeSequence;
                var newMarker = comp.markers.createMarker(marker.Timecode);
				newMarker.name = "KROCK.IO_"+marker.Commenter;
				newMarker.comments = marker.Comment;
                if(marker.TimecodeEndx != 'null'){
                    newMarker.end = marker.TimecodeEndx;//marker.TimeDifferenceDuration;
                }
				newMarker.setColorByIndex(marker.color);//.setColor(marker.color[0], marker.color[1], marker.color[2]);
				//marker.label = color;
				//layer.property("Marker").setLabel(color, marker);
            return newMarker.guid;
        } else {
            alert("Please select a composition");
        }
    },
    removeImportedMarkers: function (xMarkerGUID) {
        if (app.project && app.project.activeSequence) {
            var markers = app.project.activeSequence.markers;
            var count = markers.numMarkers;
            for( var i=count-1; i>=0; i--){
                var marker = markers[i];
                if (marker.name.startsWith('KROCK.IO_')){
                    markers.deleteMarker(marker);
                }
            }
        } else {
            alert("Please select a composition");
        }
    },
    checkActiveComposition: function () {
        if (app.project && app.project.activeSequence) {
            return 'yes';
        } else {
            alert("Please select a composition");
            return 'no';
        }
    },

    /////////////////
    // AFTER EFFECTS
    /////////////////
    addMarkersToTimelineAEFT: function (xMarker) {
        // $._ext.playPauseAEFT();
        var marker = JSON.parse(xMarker);
        if (app.project && app.project.activeItem && app.project.activeItem instanceof CompItem) {
            var comp = app.project.activeItem;
            var layers = comp.selectedLayers;
            var numLayers = layers.length;
            if (numLayers > 0) {
                for (var l = 0; l < numLayers; l++) {
                    var newMarker = new MarkerValue("KROCK.IO_"+marker.Commenter+'\n'+marker.Comment);
                    newMarker.label = marker.color; // Устанавливаем цвет маркера
                    if(!isNaN(parseFloat(marker.TimecodeEndx)) && isFinite(marker.TimecodeEndx) ){
                        if(marker.TimecodeEndx > 0){
                            newMarker.duration = (marker.TimecodeEndx - marker.Timecode);
                        }
                    }
                    var layer = layers[l];
                    layer.marker.setValueAtTime(marker.Timecode, newMarker);
                    return newMarker;
                }
            }
            return 1;
        } else {
            alert("Please select a composition");
        }
    },
    removeImportedMarkersAEFT: function () {
        var comp = app.project.activeItem;
        if (comp && comp instanceof CompItem) {
            for (var i = 0; i < comp.selectedLayers.length; i++) {
                var layer = comp.selectedLayers[i];
                if (layer.property("Marker") !== null) {
                    var markerProperty = layer.property("Marker");
                    for (var j = markerProperty.numKeys; j > 0; j--) {
                        // if (markerProperty[j].name.startsWith('KROCK.IO_')){
                        //     markerProperty.removeKey(j);
                        // }
                        var marker = markerProperty.keyValue(j);
                        if (marker.comment && marker.comment.startsWith("KROCK.IO_")) {
                            markerProperty.removeKey(j);
                        }
                    }
                }
            }
        } else {
            alert("Please select a composition and layers to remove markers");
        }
    },
    playPauseAEFT: function () {
        var comp = app.project.activeItem;
        if (comp && comp instanceof CompItem) {
            app.executeCommand(10550);
            app.executeCommand(10314);
            app.executeCommand(2131);
            //app.project.activeItem.time = '5.5';
            return true;
        } else {
            alert("Please select a composition to play");
        }
    },
    setPlayheadTimeAEFT: function (timeInSeconds) {
        try {
            if (app.project && app.project.activeItem) {
                var sequence = app.project.activeItem;
                //var ticks = parseInt(timeInSeconds * 254016000000);
                sequence.time = timeInSeconds;
                //sequence.setPlayerPosition(ticks.toString()); // Number frame
                return "Playhead set to " + timeInSeconds + " seconds.";
            } else {
                return "No active sequence found.";
            }
        } catch (e) { 
            //alert("Exception3:" + e.message);
        }
    },
    checkActiveCompositionAEFT: function () {
        var comp = app.project.activeItem;
        if (comp && comp instanceof CompItem) {
            return 'yes';
        } else {
            alert("Please select a composition");
            return 'no';
        }
    }
};