var importedMarkers = [];
var commenterColors = {};

// Playhead settings
let playheadSettings = localStorage.getItem(KROCK_CONSTANTS.STORAGE_KEY_PLAYHEAD);
if(!playheadSettings){
	localStorage.setItem(KROCK_CONSTANTS.STORAGE_KEY_PLAYHEAD, true);
} else {
	var syncPlayheadBtnX = document.getElementById('syncPlayhead');
	if(playheadSettings === 'true'){
		syncPlayheadBtnX.classList.add("btn-active");
		KROCK_CONSTANTS.STORAGE_TEMP_PLAYHEAD = true;
	} else {
		syncPlayheadBtnX.classList.remove("btn-active");
		KROCK_CONSTANTS.STORAGE_TEMP_PLAYHEAD = false;
	}
}
/////////////////////////

var syncBtn = document.getElementById('syncMarkers'); 
//console.log(syncBtn);
syncBtn.addEventListener("click", () => {
	if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
		var extScript = '$._ext.checkActiveComposition()';
		KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(extScript, (result) => {
			if (result && result === 'yes') {
				// Убедитесь, что iframe загрузился
				var iframe = document.getElementById('iframe');
				const data = { typeEvent: 'checkInfoFile' };
				iframe.contentWindow.postMessage(data, KROCK_CONSTANTS.IFRAME_ORIGIN); // Укажите точный URL или '*'
			} else {
				KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('alert("Please select a composition")');
			}
		});
	} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
		console.log("Click Sync AEFT");
		var extScript = '$._ext.checkActiveCompositionAEFT()';
		KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(extScript, (result) => {
			if (result && result === 'yes') {
				// Убедитесь, что iframe загрузился
				console.log("Click Sync AEFT 2");
				var iframe = document.getElementById('iframe');
				const data = { typeEvent: 'checkInfoFile' };
				iframe.contentWindow.postMessage(data, KROCK_CONSTANTS.IFRAME_ORIGIN); // Укажите точный URL или '*'
			} else {
				KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('alert("Please select a composition")');
			}
		});
	}
});

var removeBtn = document.getElementById('removeMarkers'); 
//console.log(removeBtn);
removeBtn.addEventListener("click", () => {
	if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
		var extScript = '$._ext.removeImportedMarkers()';
		KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(extScript, (result) => {
			if (result) {
				console.log("Delete markers");
				console.log("Result:", result);

				importedMarkers = []; // Очищаем список маркеров
				updateStatus();
			} else {
				console.error("EvalScript failed.");
			}
		});
	} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
		var extScript = '$._ext.removeImportedMarkersAEFT()';
		KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(extScript, (result) => {
			if (result) {
				console.log("Delete markers");
				console.log("Result:", result);

				importedMarkers = []; // Очищаем список маркеров
				updateStatus();
			} else {
				console.error("EvalScript failed.");
			}
		});
	}
});

var syncPlayheadBtn = document.getElementById('syncPlayhead'); 
//console.log(removeBtn);
syncPlayheadBtn.addEventListener("click", () => {
	var syncPlayheadBtnX = document.getElementById('syncPlayhead');
	let playhead = localStorage.getItem(KROCK_CONSTANTS.STORAGE_KEY_PLAYHEAD);
	console.log(playhead);
	if(playhead === 'true'){
		localStorage.setItem(KROCK_CONSTANTS.STORAGE_KEY_PLAYHEAD, false);
		syncPlayheadBtnX.classList.remove("btn-active");
		KROCK_CONSTANTS.STORAGE_TEMP_PLAYHEAD = false;
	} else {
		localStorage.setItem(KROCK_CONSTANTS.STORAGE_KEY_PLAYHEAD, true);
		syncPlayheadBtnX.classList.add("btn-active");
		KROCK_CONSTANTS.STORAGE_TEMP_PLAYHEAD = true;
	}
});


function updateStatus()
{
	var status = document.getElementById('status');
	status.innerHTML = `Imported: ${importedMarkers.length} markers`;
}

// Recieve post event iframe
const eventTimestamps = new Map();
const EVENT_THRESHOLD = 1000; // miliseconds
window.addEventListener('message', (event) => {
	if (!event.data || !event.data.event) return;
	const eventName = event.data.event;
	const now = Date.now();
	if (eventTimestamps.has(eventName)) {
		const lastTimestamp = eventTimestamps.get(eventName);
		if (now - lastTimestamp < EVENT_THRESHOLD) {
			return; // Ignore duplicate
		}
	}
	eventTimestamps.set(eventName, now);
	//console.log('Event in iframe:', event.data, ' time:', new Date(now).toISOString());

	if (event.origin !== KROCK_CONSTANTS.IFRAME_ORIGIN) return;

	if(event.data.event == "updateInfoFile" && event.data.status == "success"){
		syncMarkers(event.data.data.mediaId);
	} else if(event.data.event == "updateInfoFile" && event.data.status != "success"){
		KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('alert("Please select a video file on the Krock.io platform")');
	}
});

// Sync Markers
function syncMarkers(mediaId){
	const token = localStorage.getItem(KROCK_CONSTANTS.STORAGE_KEY_TOKEN);
	if(!token){
		KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('alert("Please login Krock.io platform")');
	} else {
		fetch(KROCK_CONSTANTS.IFRAME_ORIGIN+'/api/web/v1/steps/fetch-public-markers'+'/?mediaId='+mediaId+'&token='+token)
		.then((response) => {
			if (!response.ok) {
				//throw new Error(`HTTP error! status: ${response.status}`);
				KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript('alert("Please login Krock.io platform")');
			}
			return response.json();
		})
		.then((data) => {
			var markers = data.data;
			//console.log(markers);
			importedMarkers = [];
			for (var i = 0; i < markers.length; i++) {
				var markerData = markers[i];
				var commenter = markerData.Commenter;
				var color = 1;
				if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
					color = getColorForCommenter(commenter, 7);
				} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
					color = getColorForCommenter(commenter, 16);
				}
				//let timeMarker = markerData.Timecode;

				var req = JSON.stringify({
					'Timecode': markerData.Timecode,
					'TimecodeEndx': (markerData.TimecodeEnd > 0) ? markerData.TimecodeEnd : 'null',
					'TimeDifferenceDuration': (markerData.TimecodeEnd > 0) ? (markerData.TimecodeEnd - markerData.Timecode) : 'null',
					'Commenter': markerData.Commenter,
					'Comment': markerData.Comment,
					'color': color
				});

				if(KROCK_CONSTANTS.APP_NAME == 'PPRO'){
					var extScript = '$._ext.addMarkersToTimeline(\'' + req + '\')';
					KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(extScript, (guidMarker) => {
						if (guidMarker) {
							// console.log("Sync markers/Result:");
							// console.log(guidMarker);
							importedMarkers.push({
								guidMarker,
							});
							updateStatus();
						}
					});
				} else if(KROCK_CONSTANTS.APP_NAME == 'AEFT'){
					console.log("Click Sync AEFT");
					var extScript = '$._ext.addMarkersToTimelineAEFT(\'' + req + '\')';
					KROCK_CONSTANTS.GLOBAL_CSINTERFACE.evalScript(extScript, (guidMarker) => {
						if (guidMarker) {
							console.log("Sync markers/Result:");
							console.log(guidMarker);
							importedMarkers.push({
								guidMarker,
							});
							updateStatus();
						}
					});
				}
			}
		})
		.catch((error) => {
			console.log('Error: '+error.message);
		});
	}
}

function getRandomColor(max) { // 16 | 7
	return Math.floor(Math.random() * (max - 1 + 1)) + 1;
}

function getColorForCommenter(commenter, max) {
    if (!commenterColors[commenter]) {
        commenterColors[commenter] = getRandomColor(max);
    }
    return commenterColors[commenter];
}